//Time stuff.
var FPS = 60;
var delayTime = 850/FPS;
var lastTime = GetTime();

/*----------------------------------\*
||           Menu object            ||
\*----------------------------------*/
function Menu(options, x, y)
{
	this.options = options;
	this.done = false;
	this.cancelled = false;
	
	if (x != undefined) this.x = x;		else this.x = 0;
	if (y != undefined) this.y = y;		else this.y = 0;
	
	this.optionHeight = 16;		//Vertical amount of pixels reserved for options.
	this.optionWidth = 64;		//Same, but for width.
	
	this.windowStyle = GetSystemWindowStyle();
	this.font = GetSystemFont();
	
	this.selectedCell = 0;
}



Menu.prototype.execute = function()
{
	while (!this.done) this.loop();
	if (this.cancelled) this.selectedCell = undefined;
}


// THE ACTUAL LOOP
Menu.prototype.loop = function()
{
	if(GetTime() > lastTime + delayTime)
	{
		lastTime = GetTime();
		this.preRender();
		this.render();
		this.postRender();
		FlipScreen();
		
		this.checkKeys();
	}
}


Menu.prototype.render = function()
{
	if (this.windowStyle != undefined)
		this.windowStyle.drawWindow(this.x, this.y, (this.options.length*this.optionWidth), ((this.options.length)*this.optionHeight));

	//Find each element in this specific subarray.
	for (var cell = 0; cell < this.options.length; cell++)
	{
		//Change colour if it's the option that is selected.
		if (this.selectedCell == cell)
			this.font.setColorMask(CreateColor(252,252,84));
		
		//Draw it on screen, on position (column number, element number).
		this.font.drawText(this.x, this.y + (cell*this.optionHeight), this.options[cell]);
		
		if (this.selectedCell == cell)
			this.font.setColorMask(CreateColor(255,255,255));
	}
}


Menu.prototype.preRender = function()
{
	//To show the background and stuff.
}

Menu.prototype.postRender = function()
{
	//For extra effects.
}


Menu.prototype.checkKeys = function()
{
	//KEYPRESSES CHECKIN'
	if ((IsKeyPressed(KEY_UP)) && this.selectedCell > 0)
		this.selectedCell--;
	
	if ((IsKeyPressed(KEY_DOWN)) && this.selectedCell < this.options.length-1)
		this.selectedCell++;
	
	if (IsKeyPressed(KEY_CTRL) || IsKeyPressed(KEY_ENTER))
		this.done = true;
	
	if (IsKeyPressed(KEY_ESCAPE))
		this.done = true, this.cancelled = true;
	
	
	//Render the bunch while waiting for a keypress.
	while (IsAnyKeyPressed()) this.render();
}

